/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.LayoutManager;
import jclass.bwt.JCContainer;
import jclass.bwt.JCTabButton;
import jclass.bwt.JCTabManagerEvent;
import jclass.bwt.JCTabManagerListener;
import jclass.bwt.LabelConverter;
import jclass.bwt.TabManagerConverter;
import jclass.bwt.TabPageArea;
import jclass.bwt.TabPanel;
import jclass.util.JCVector;

public class JCTabManager
extends JCContainer {
    public static final int TOPLEFT = 0;
    public static final int LEFT = 0;
    public static final int TOPCENTER = 1;
    public static final int CENTER = 1;
    public static final int TOPRIGHT = 2;
    public static final int RIGHT = 2;
    public static final int MIDDLELEFT = 3;
    public static final int MIDDLECENTER = 4;
    public static final int MIDDLE = 4;
    public static final int MIDDLERIGHT = 5;
    public static final int BOTTOMLEFT = 6;
    public static final int BOTTOMCENTER = 7;
    public static final int BOTTOMRIGHT = 8;
    public static final int COLOR_PAGE = 0;
    public static final int COLOR_INHERIT = 1;
    public static final int RECTANGLE = 0;
    public static final int SLANTED = 1;
    public static final int TOP = 1;
    public static final int BOTTOM = 5;
    Component current_page;
    int current_tab;
    int first_tab;
    int last_tab;
    int tab_alignment = 4;
    int tab_color_policy = 0;
    Font tab_current_font;
    boolean tab_resize = true;
    boolean tab_stretch = false;
    int tab_side = 1;
    int tab_spacing = -999;
    int tab_shape = 0;
    boolean show_page = true;
    String[] tab_labels;
    protected TabPanel tab_panel;
    protected TabPageArea page_area;
    protected JCVector listeners = new JCVector(0);
    private static final String base = "tabmanager";
    private static int nameCounter;
    boolean first = true;

    public JCTabManager() {
        this(null, null);
    }

    public JCTabManager(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        super.setLayout(new BorderLayout());
        this.tab_panel = new TabPanel(this);
        this.page_area = new TabPageArea(this);
        this.add("Center", this.page_area);
        this.setTabSide(1);
        if (this.getClass().getName().equals("jclass.bwt.JCTabManager")) {
            this.getParameters(applet);
        }
    }

    protected void getParameters() {
        super.getParameters();
        TabManagerConverter.getParams(this);
    }

    public void addTabManagerListener(JCTabManagerListener jCTabManagerListener) {
        this.listeners.add(jCTabManagerListener);
    }

    public void removeTabManagerListener(JCTabManagerListener jCTabManagerListener) {
        this.listeners.removeElement(jCTabManagerListener);
    }

    public Component[] getPages() {
        return this.page_area.getComponents();
    }

    public JCTabButton[] getTabs() {
        JCTabButton[] jCTabButtonArray = new JCTabButton[this.tab_panel.countComponents()];
        int n = 0;
        while (n < jCTabButtonArray.length) {
            jCTabButtonArray[n] = (JCTabButton)this.tab_panel.getComponents()[n];
            ++n;
        }
        return jCTabButtonArray;
    }

    public int getTab(JCTabButton jCTabButton) {
        Component[] componentArray = this.tab_panel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == jCTabButton) {
                return n;
            }
            ++n;
        }
        return -999;
    }

    public JCTabButton getTab(int n) {
        Component component;
        Component[] componentArray = this.tab_panel.getComponents();
        Component component2 = component = n >= 0 && n < componentArray.length ? componentArray[n] : null;
        if (component instanceof JCTabButton) {
            return (JCTabButton)component;
        }
        return null;
    }

    public int getAlignment() {
        return this.tab_alignment;
    }

    public synchronized void setAlignment(int n) {
        LabelConverter.checkAlignment(n);
        this.tab_alignment = n;
        if (this.getPeer() == null) {
            return;
        }
        JCTabButton[] jCTabButtonArray = this.getTabs();
        int n2 = 0;
        while (n2 < jCTabButtonArray.length) {
            if (jCTabButtonArray[n2].getAlignment() == -999) {
                jCTabButtonArray[n2].setAlignment(n);
                jCTabButtonArray[n2].alignment = -999;
            }
            ++n2;
        }
    }

    public int getTabColorPolicy() {
        return this.tab_color_policy;
    }

    public synchronized void setTabColorPolicy(int n) {
        TabManagerConverter.checkColorPolicy(n);
        this.tab_color_policy = n;
        this.repaint();
    }

    public int getTabSpacing() {
        return this.tab_spacing;
    }

    public void setTabSpacing(int n) {
        this.tab_spacing = n;
        this.tab_panel.layout();
    }

    public int getCurrentTab() {
        return this.current_tab;
    }

    public synchronized void setCurrentTab(int n, boolean bl) {
        JCTabButton jCTabButton = this.getTab(this.current_tab);
        JCTabButton jCTabButton2 = this.getTab(n);
        if (jCTabButton2 == null) {
            return;
        }
        Component component = null;
        JCTabManagerEvent jCTabManagerEvent = null;
        this.show_page = bl;
        if (bl) {
            component = jCTabButton2.page;
        }
        if (bl && this.listeners.size() > 0) {
            Event event = new Event(this, 0, null);
            event.when = System.currentTimeMillis();
            event.target = this;
            event.id = 1001;
            jCTabManagerEvent = new JCTabManagerEvent(event, this.current_page, jCTabButton, component, jCTabButton2);
            int n2 = 0;
            while (n2 < this.listeners.size()) {
                ((JCTabManagerListener)this.listeners.elementAt(n2)).tabManagerChangeBegin(jCTabManagerEvent);
                if (!jCTabManagerEvent.doit) {
                    return;
                }
                component = jCTabManagerEvent.next_page;
                jCTabButton2 = this.getTab(n);
                ++n2;
            }
        }
        this.tab_panel.restoreStackingOrder();
        if (jCTabButton != null && jCTabButton2 != jCTabButton) {
            jCTabButton.resize(false);
        }
        if (jCTabButton2 != null) {
            jCTabButton2.resize(true);
        }
        this.current_tab = n;
        this.tab_panel.repaint();
        this.setCurrentPage(bl ? component : this.current_page);
        if (bl && this.listeners.size() > 0) {
            int n3 = 0;
            while (n3 < this.listeners.size()) {
                ((JCTabManagerListener)this.listeners.elementAt(n3)).tabManagerChangeEnd(jCTabManagerEvent);
                ++n3;
            }
        }
    }

    public Font getCurrentTabFont() {
        return this.tab_current_font;
    }

    public synchronized void setCurrentTabFont(Font font) {
        this.tab_current_font = font;
        this.tab_panel.repaint();
    }

    public Component getCurrentPage() {
        return this.current_page;
    }

    public synchronized void setCurrentPage(Component component) {
        this.current_page = component;
        this.page_area.showPage(component);
    }

    public int getTabShape() {
        return this.tab_shape;
    }

    public synchronized void setTabShape(int n) {
        TabManagerConverter.checkTabShape(n);
        this.tab_shape = n;
        this.tab_panel.setTabShape(n);
    }

    public String[] getTabLabels() {
        return this.tab_labels;
    }

    public synchronized void setTabLabels(String[] stringArray) {
        this.tab_labels = stringArray;
        if (this.tab_labels == null) {
            return;
        }
        int n = 0;
        while (n < this.tab_labels.length) {
            JCTabButton jCTabButton = this.getTab(n);
            if (jCTabButton == null) break;
            jCTabButton.setLabel(this.tab_labels[n]);
            ++n;
        }
        this.tab_panel.layout();
    }

    public int getFirstVisibleTab() {
        return this.first_tab;
    }

    public synchronized void setFirstVisibleTab(int n) {
        if (this.tab_panel.allTabsVisible() || n < 0 || n > this.tab_panel.countTabs() - 1) {
            return;
        }
        this.first_tab = n;
        this.tab_panel.layout();
    }

    public synchronized void makeTabVisible(int n) {
        if (this.tab_panel.allTabsVisible() || n < 0 || n > this.tab_panel.countTabs() - 1) {
            return;
        }
        if (n < this.first_tab) {
            this.setFirstVisibleTab(n);
            return;
        }
        if (n > this.last_tab) {
            this.setFirstVisibleTab(this.first_tab + n - this.last_tab);
        }
    }

    public boolean getTabResize() {
        return this.tab_resize;
    }

    public synchronized void setTabResize(boolean bl) {
        this.tab_resize = bl;
        this.tab_panel.layout();
    }

    public int getTabSide() {
        return this.tab_side;
    }

    public synchronized void setTabSide(int n) {
        TabManagerConverter.checkTabSide(n);
        this.tab_side = n;
        String string = n == 0 ? "West" : (n == 2 ? "East" : (n == 5 ? "South" : "North"));
        this.remove(this.tab_panel);
        super.add(string, this.tab_panel);
        if (this.getPeer() == null) {
            return;
        }
        this.layout();
        this.repaint();
    }

    public boolean getTabStretch() {
        return this.tab_stretch;
    }

    public synchronized void setTabStretch(boolean bl) {
        this.tab_stretch = bl;
        this.tab_panel.layout();
    }

    public synchronized int setTabPage(int n, Object object, Component component) {
        JCTabButton jCTabButton = this.getTab(n);
        if (jCTabButton == null) {
            jCTabButton = new JCTabButton(this);
            this.tab_panel.add(jCTabButton);
        }
        this.page_area.addPage(component);
        jCTabButton.page = component;
        if (object == null && this.tab_labels != null && this.tab_labels.length > (n = this.getTab(jCTabButton))) {
            object = this.tab_labels[n];
        }
        jCTabButton.setLabel(object);
        if (this.getPeer() != null) {
            this.tab_panel.invalidate();
            this.validate();
        }
        return this.getTab(jCTabButton);
    }

    public synchronized int addPage(Object object, Component component) {
        return this.setTabPage(Integer.MAX_VALUE, object, component);
    }

    public synchronized void removeTab(int n, boolean bl) {
        JCTabButton jCTabButton = this.getTab(n);
        if (jCTabButton == null || jCTabButton.getParent() != this.tab_panel) {
            return;
        }
        if (bl && jCTabButton.page != null) {
            this.page_area.remove(jCTabButton.page);
        }
        this.tab_panel.remove(jCTabButton);
    }

    public Component add(Component component) {
        if (component instanceof TabPanel || component instanceof TabPageArea) {
            return super.add(component);
        }
        this.addPage(null, component);
        return component;
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n4 < 0) {
            return;
        }
        if (n == this.location().x && n2 == this.location().y && n3 == this.size().width && n4 == this.size().height) {
            return;
        }
        super.reshape(n, n2, n3, n4);
        if (this.first) {
            this.setCurrentTab(this.current_tab, this.show_page);
        }
        this.first = false;
    }
}

